#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "HSEmbeddedHttpRequest.h"
#include "HSEmbeddedHttpDef.h"
#include <QMessageBox>
#include <QFileDialog>
#include "rtsdialog.h"
#include "pbsdialog.h"
#include <QtConcurrent/QtConcurrent>

#define HANDEL *void
typedef struct HTTP_LOGIN_CONTEXT_ {
    void* pHwnd;
    void* pMyHandle;
    int index;
    int nUpgradePer;
    HTTP_LOGIN_CONTEXT_() {
        pHwnd = NULL;
        pMyHandle = NULL;
        index = -1;
        nUpgradePer = 0;
    }
}HTTP_LOGIN_CONTEXT, *pHTTP_LOGIN_CONTEXT;

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void init();
    void showMsg(QString text);
    static void FUN_CALL HttpMsgCallBack_Batch(void *handle, long msgType, void *lpStruct, void *lpContext);
    void updatePer();

    void runTest();
private slots:
    void on_pushButton_clicked();

    void on_pb_send_clicked();

    void DealHttpCallBackMsg_Batch(uint msg, void *lpContext, void *lpStruct);

    void on_pb_browse_clicked();

    void on_pb_upgrade_clicked();

    void on_pb_logout_clicked();

    void on_pb_rts_clicked();

    void on_pb_pbs_clicked();

    void on_pb_opentalk_clicked();

    void on_pb_closetalk_clicked();

    void on_pb_testSend_clicked();

signals:
    void signals_HttpCallBackMessage_Batch(uint msg, void *lpContext, void *lpStruct);

private:
    Ui::MainWindow *ui;
    HTTP_LOGIN_CONTEXT m_HttpContext[10];
    HS_HTTP_INFO *clientinfo;

    RTSDialog *rtsDlg;
    PBSDialog *pbsDlg;
};

#endif // MAINWINDOW_H
