#include "pbsdialog.h"
#include "ui_pbsdialog.h"
#include <QDebug>

PBSDialog::PBSDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PBSDialog)
{
    ui->setupUi(this);
    ui->ed_speed->setText ("0");
    ui->ed_seek->setText ("0");
    //ui->label->setStyleSheet ("QLabel{backgound-color:black;}");
    m_nChannel = 0;
    m_nStream = 0;
    m_nSound = 1;
    m_nStartTime = 0;
    m_nEndTime = 0;
    m_nFileType = 0;
    m_nSpeed = 0;
    m_nSeek = 0;
    m_hClientHandle = NULL;
}

PBSDialog::~PBSDialog()
{
    delete ui;
}

void PBSDialog::closeStream () {
    HS_HTTP_ClosePlayBackStream (m_hClientHandle, m_nChannel, m_nStream);
}

void PBSDialog::PBSMsgCallBack_Batch(void *handle, long msgType, void *lpStruct, void *lpContext) {
    qDebug() << QString::number (msgType);
}

void PBSDialog::setParam (TmpInfo info) {
    m_nChannel = info.nChannel;
    m_nStream = info.nStream;
    m_nSound = info.nSound;
    m_nStartTime = info.nStartTime;
    m_nEndTime = info.nEndTime;
    m_nFileType = info.nFileType;
    m_nSpeed = info.nSpeed;
    m_nSeek = info.nSeek;
    m_hClientHandle = info.hClientHandle;
    m_content.hHandle = info.hClientHandle;
    m_content.nChannel = info.nChannel;
    m_content.nStream = info.nStream;
}

void PBSDialog::on_pb_play_clicked()
{
    HS_HTTP_PLAYBACK_INFO streamInfo;
    memset(&streamInfo, 0, sizeof(HS_HTTP_PLAYBACK_INFO));
    streamInfo.nChannel = m_nChannel;
    streamInfo.nStream = m_nStream;
    streamInfo.hVideoWnd = (HWND)ui->label->winId ();
    streamInfo.nSound = m_nSound;
    streamInfo.nStartTime = m_nStartTime;
    streamInfo.nEndTime = m_nEndTime;
    streamInfo.nFileType = m_nFileType;
    streamInfo.nSpeed = m_nSpeed;
    streamInfo.msgFun = PBSMsgCallBack_Batch;
    streamInfo.lpContext = (void*)(&m_content);
    HS_HTTP_OpenPlayBackStream (m_hClientHandle, &streamInfo);
}

void PBSDialog::on_pb_stop_clicked()
{
    HS_HTTP_ClosePlayBackStream (m_hClientHandle, m_nChannel, m_nStream);
}


void PBSDialog::on_pb_pause_clicked()
{
    HS_HTTP_SetPlayBackStatus (m_hClientHandle, m_nChannel, m_nStream, 0);
}

void PBSDialog::on_pb_continue_clicked()
{
    HS_HTTP_SetPlayBackStatus (m_hClientHandle, m_nChannel, m_nStream, 1);
}

void PBSDialog::on_pb_opensound_clicked()
{
    HS_HTTP_SetPlayBackSound (m_hClientHandle, m_nChannel, m_nStream, true);
}

void PBSDialog::on_pb_closesound_clicked()
{
    HS_HTTP_SetPlayBackSound (m_hClientHandle, m_nChannel, m_nStream, false);
}

void PBSDialog::on_pb_startrec_clicked()
{
    QString path = QCoreApplication::applicationDirPath () + "\\testPBS_SRecord\\test.avi";
    HS_HTTP_StartPlayBackRecord (m_hClientHandle, m_nChannel, m_nStream, path.toStdString ().c_str ());
}

void PBSDialog::on_pb_stoprec_clicked()
{
    HS_HTTP_StopPlayBackRecord (m_hClientHandle, m_nChannel, m_nStream);
}

void PBSDialog::on_pb_setspeed_clicked()
{
    int speed = ui->ed_speed->text().toInt ();
    HS_HTTP_SetPlayBackSpeed (m_hClientHandle, m_nChannel, m_nStream, speed);
}

void PBSDialog::on_pb_setseek_clicked()
{
    int seek = ui->ed_seek->text().toInt ();
    HS_HTTP_SetPlayBackSeek (m_hClientHandle, m_nChannel, m_nStream, seek);
}
