#ifndef RTSDIALOG_H
#define RTSDIALOG_H

#include <QDialog>
#include "HSEmbeddedHttpDef.h"
#include "HSEmbeddedHttpRequest.h"
#include <QRect>
#include <QDesktopWidget>
#include <QCoreApplication>
#include <QFileDialog>

namespace Ui {
class RTSDialog;
}

typedef struct _RTS_Content {
    HANDLE hHandle;
    int nChannel;
    int nStream;
}RTS_Content;

class RTSDialog : public QDialog
{
    Q_OBJECT

public:
    RTSDialog(QWidget *parent = 0);
    ~RTSDialog();

    void setParam(HANDLE handle, int nChannel, int nStream, int nSound);
    void closeStream();

    static void FUN_CALL RTSMsgCallBack_Batch(void *handle, long msgType, void *lpStruct, void *lpContext);
protected:

private slots:
    void on_pb_play_clicked();
    void on_pb_stop_clicked();
    void on_pb_opensound_clicked();
    void on_pb_closesound_clicked();
    void on_pb_startRec_clicked();
    void on_pb_stopRec_clicked();

private:
    Ui::RTSDialog *ui;
    int m_nChannel;
    int m_nStream;
    int m_nSound;
    HANDLE m_hClientHandle;
    RTS_Content m_content;
};

#endif // RTSDIALOG_H
