#include "rtsdialog.h"
#include "ui_rtsdialog.h"
#include <QDebug>
RTSDialog::RTSDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::RTSDialog)
{
    ui->setupUi(this);
    ui->playWnd->setStyleSheet ("QLabel{background-color:black;}");
    m_nChannel = 0;
    m_nStream = 0;
    m_nSound = 0;
    m_hClientHandle = NULL;
    memset(&m_content, 0, sizeof(RTS_Content));
}

RTSDialog::~RTSDialog()
{
    delete ui;
    closeStream();
}

void RTSDialog::RTSMsgCallBack_Batch(void *handle, long msgType, void *lpStruct, void *lpContext) {
    qDebug() << QString::number (msgType);
}

void RTSDialog::setParam (HANDLE handle, int nChannel, int nStream, int nSound) {
    m_hClientHandle = handle;
    m_nChannel = nChannel;
    m_nStream = nStream;
    m_nSound = nSound;
    m_content.hHandle = handle;
    m_content.nChannel = nChannel;
    m_content.nStream = nStream;
}

void RTSDialog::closeStream () {
    HS_HTTP_CloseRealTimeStream (m_hClientHandle, m_nChannel, m_nStream);
}

void RTSDialog::on_pb_play_clicked() {
    HS_HTTP_REALTIME_INFO streamInfo;
    memset(&streamInfo, 0, sizeof(HS_HTTP_REALTIME_INFO));
    streamInfo.nChannel = m_nChannel;
    streamInfo.nStream = m_nStream;
    streamInfo.hVideoWnd = (HWND)this->ui->playWnd->winId ();
    streamInfo.nSound = m_nSound;
    streamInfo.msgFun = NULL;
    streamInfo.lpContext = NULL;
    streamInfo.msgFun = RTSMsgCallBack_Batch;
    streamInfo.lpContext = (void*)(&m_content);
    HS_HTTP_OpenRealTimeStream (m_hClientHandle, &streamInfo);
}

void RTSDialog::on_pb_stop_clicked()
{
    HS_HTTP_CloseRealTimeStream (m_hClientHandle, m_nChannel, m_nStream);
}

void RTSDialog::on_pb_opensound_clicked()
{
    HS_HTTP_SetRealTimeSound (m_hClientHandle, m_nChannel, m_nStream, 1);
}

void RTSDialog::on_pb_closesound_clicked()
{
    HS_HTTP_SetRealTimeSound (m_hClientHandle, m_nChannel, m_nStream, 0);
}

void RTSDialog::on_pb_startRec_clicked()
{
    QString path = QCoreApplication::applicationDirPath () + "\\testPBS_SRecord\\test.avi";
    HS_HTTP_StartRealTimeRecord (m_hClientHandle,m_nChannel, m_nStream, path.toStdString ().c_str ());
}

void RTSDialog::on_pb_stopRec_clicked()
{
    HS_HTTP_StopRealTimeRecord (m_hClientHandle,m_nChannel, m_nStream);
}
