﻿#ifndef __HTTPSTRUCTDEF_H__
#define __HTTPSTRUCTDEF_H__
#pragma pack(push)
#pragma pack(4)

#define MAX_SERVER_NAME_LEN 32
#define MAX_USER_NAME_LEN 32
#define MAX_PASSWORD_LEN 32

#define CALLBACK
#ifdef WIN32
#define FUN_CALL __stdcall
#else
typedef void* HANDLE;
typedef void* HWND;
#define FUN_CALL
#endif

// 回调函数
typedef void(FUN_CALL *HsHttpMessageCallBack)(HANDLE handle, long msgType, void *lpStruct, void *lpContext);
// 实时流回调消息
typedef void(CALLBACK *RealTimeMessageCallBack)(HANDLE handle, long msgType, void *lpStruct, void *lpContext);
// 回放流回调消息
typedef void(CALLBACK *PlayBackMessageCallBack)(HANDLE handle, long msgType, void *lpStruct, void *lpContext);
// 对讲流回调消息
typedef void(CALLBACK *TalkMessageCallBack)(HANDLE handle, long msgType, void *lpStruct, void *lpContext);

typedef enum __enumHttpRequestMsg {
    HS_HTTP_MSG_LOGINOK = 0x1000,
    HS_HTTP_MSG_LOGINFAIL,
    HS_HTTP_MSG_NOCONNECT,
    HS_HTTP_MSG_UPLOADFILE_FAIL,
    HS_HTTP_MSG_UPLOADFILE_PERCENT,
    HS_HTTP_MSG_UPLOADFILE_RESULT,
}HttpRequestMsg;

typedef enum __enumRealTimeStreamMsg {
    HS_HTTP_RTS_CALL_SUCCESS = 0x1100,
    HS_HTTP_RTS_CALL_FAIL,
    HS_HTTP_RTS_TOOMUCH_CONNECT,
}HS_HTTP_RealTimeStreamMsg;

typedef enum __enumPlayBackStreamMsg {
    HS_HTTP_PBS_CALL_SUCCESS = 0x1200,
    HS_HTTP_PBS_CALL_FAIL,
    HS_HTTP_PBS_PLAYBACK_FINISH,
    HS_HTTP_PBS_CONNECT_TOOMUCH,
    HS_HTTP_PBS_RECORDFILE_ERROR,
    HS_HTTP_PBS_DOWNLOADFILE_PER,
    HS_HTTP_PBS_DOWNLOADFILE_FAIL,
}HS_HTTP_PlayBackStreamMsg;

typedef struct _HS_HTTP_INFO {
    int nPort;               //端口
    char cIpAddress[32];            //IP地址
    char cUsername[MAX_USER_NAME_LEN]; //用户名
    char cPassword[MAX_PASSWORD_LEN];  //密码

    int nSendtime;       //发送时间,单位mesc
    int nRecvtime;       //接收时间,单位mesc
    int nConnecttime;

    int nTryNum;         //重连次数
    int nTryInterval;    //重连间隔,单位mesc
    void *lpContext;
    HsHttpMessageCallBack msgFun;
}HS_HTTP_INFO;

typedef struct _HS_HTTP_CALL_PARAM {
    int nPost;    // 0:Get   1:Post
    char cUrl[256];
    char *cJsonData;
}HS_HTTP_CALL_PARAM;


typedef struct _HS_HTTP_REALTIME_INFO {
    unsigned int nChannel;  // 通道号,IPC没有不用填
    unsigned int nStream;   // 码流 0,1,2

    HWND hVideoWnd;   // 视频窗口句柄

    unsigned int nSound; // 开启声音
    void *lpContext;             // 回调自定义参数
    RealTimeMessageCallBack msgFun; // 消息回调函数
}HS_HTTP_REALTIME_INFO;

typedef struct _HS_HTTP_PLAYBACK_INFO {
    unsigned int nChannel;  // 通道号,IPC没有不用填
    unsigned int nStream;   // 码流 0,1,2

    HWND hVideoWnd;   // 视频窗口句柄

    int nFileType;      // 录像类型
    int nSpeed;

    unsigned int nStartTime;
    unsigned int nEndTime;

    unsigned int nSound; // 开启声音
    void *lpContext;             // 回调自定义参数
    PlayBackMessageCallBack msgFun; // 消息回调函数
}HS_HTTP_PLAYBACK_INFO;

#pragma pack(pop)

#endif
