﻿#include "HSEmbeddedHttpDef.h"
#define HTTPCLIENT_EXPORTS

#ifdef WIN32
#ifdef HTTPCLIENT_EXPORTS
#define HTTP_DLLAPI __declspec(dllexport)
#else
#define HTTP_DLLAPI __declspec(dllimport)
#endif
#else
#define HTTP_DLLAPI
#endif

#ifdef __cplusplus
extern "C" {
#endif

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_Startup();

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_Cleanup();

    HTTP_DLLAPI HANDLE FUN_CALL HS_HTTP_Login(HS_HTTP_INFO *pHttpInfo);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_Logout(HANDLE hHandle);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_Call(HANDLE hHandle, HS_HTTP_CALL_PARAM *pData, char **pRet);

    //释放Call返回的内存，window下需要调用这个，不然会崩溃，linux下不需要
    HTTP_DLLAPI void FUN_CALL HS_HTTP_FreeCallBuf(void *buf);
    //bAsyn:true 异步发送，ret:true  线程启动成功即将开始发送
    //bAsyn:false 同步发送，ret:true  文件发送成功
    HTTP_DLLAPI bool FUN_CALL HS_HTTP_Upgrade(HANDLE hHandle, char* filepath, bool bAsyn = true);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_UploadFile(HANDLE hHandle, const char* url, char* filepath, char **ret, bool bAsyn = false);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_CheckSupport(const char *cIp, int nPort);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_GetSessionID(HANDLE hHandle, char *cSession);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_SetSessionID(HANDLE hHandle, char *cSession);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_OpenRealTimeStream(HANDLE hHandle, HS_HTTP_REALTIME_INFO *info);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_CloseRealTimeStream(HANDLE hHandle, int nChannel, int nStream);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_SetRealTimeSound(HANDLE hHandle, int nChannel, int nStream, bool bEnable);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_StartRealTimeRecord(HANDLE hHandle, int nChannel, int nStream, const char *filename);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_StopRealTimeRecord(HANDLE hHandle, int nChannel, int nStream);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_OpenPlayBackStream(HANDLE hHandle, HS_HTTP_PLAYBACK_INFO *info);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_ClosePlayBackStream(HANDLE hHandle, int nChannel, int nStream);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_SetPlayBackSound(HANDLE hHandle, int nChannel, int nStream, bool bEnable);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_StartPlayBackRecord(HANDLE hHandle, int nChannel, int nStream, const char *filename);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_StopPlayBackRecord(HANDLE hHandle, int nChannel, int nStream);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_SetPlayBackSpeed(HANDLE hHandle, int nChannel, int nStream, int nSpeed);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_SetPlayBackSeek(HANDLE hHandle, int nChannel, int nStream, int nSeek);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_SetPlayBackStatus(HANDLE hHandle, int nChannel, int nStream, int nSta);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_OpenTalk(HANDLE hHandle);

    HTTP_DLLAPI bool FUN_CALL HS_HTTP_CloseTalk(HANDLE hHandle);
#ifdef __cplusplus
}
#endif
