#ifndef PBSDIALOG_H
#define PBSDIALOG_H

#include <QDialog>
#include "HSEmbeddedHttpDef.h"
#include "HSEmbeddedHttpRequest.h"
#include <QRect>
#include <QDesktopWidget>
#include <QCoreApplication>
#include <QFileDialog>

namespace Ui {
class PBSDialog;
}

typedef struct _PBS_Content {
    HANDLE hHandle;
    int nChannel;
    int nStream;
}PBS_Content;

typedef struct _tmpInfo {
    int nChannel;
    int nStream;
    int nSound;

    int nStartTime;
    int nEndTime;
    int nFileType;
    int nSpeed;
    int nSeek;
    HANDLE hClientHandle;
}TmpInfo;

class PBSDialog : public QDialog
{
    Q_OBJECT

public:
    PBSDialog(QWidget *parent = 0);
    ~PBSDialog();

    static void FUN_CALL PBSMsgCallBack_Batch(void *handle, long msgType, void *lpStruct, void *lpContext);
public:
    void setParam(TmpInfo info);
    void closeStream();

private slots:
    void on_pb_play_clicked();

    void on_pb_pause_clicked();

    void on_pb_continue_clicked();

    void on_pb_opensound_clicked();

    void on_pb_closesound_clicked();

    void on_pb_startrec_clicked();

    void on_pb_stoprec_clicked();

    void on_pb_setspeed_clicked();

    void on_pb_setseek_clicked();

    void on_pb_stop_clicked();

private:
    Ui::PBSDialog *ui;
    int m_nChannel;
    int m_nStream;
    int m_nSound;

    int m_nStartTime;
    int m_nEndTime;
    int m_nFileType;
    int m_nSpeed;
    int m_nSeek;
    HANDLE m_hClientHandle;
    PBS_Content m_content;
};

#endif // PBSDIALOG_H
